/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.xml.parsers.ParserConfigurationException;
import org.autoplot.AutoplotUtil;
import org.autoplot.GuiSupport;
import org.autoplot.MouseModuleType;
import org.autoplot.PlotStylePanel;
import org.autoplot.RenderType;
import org.autoplot.Util;
import org.autoplot.bookmarks.Bookmark;
import org.autoplot.bookmarks.BookmarksException;
import org.autoplot.datasource.AutoplotSettings;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.DataSource;
import org.autoplot.datasource.HtmlResponseIOException;
import org.autoplot.datasource.URISplit;
import org.autoplot.datasource.capability.Caching;
import org.autoplot.dom.Application;
import org.autoplot.dom.ApplicationController;
import org.autoplot.dom.CanvasController;
import org.autoplot.dom.CanvasUtil;
import org.autoplot.dom.DataSourceController;
import org.autoplot.dom.DataSourceFilter;
import org.autoplot.dom.DomUtil;
import org.autoplot.dom.Plot;
import org.autoplot.dom.PlotElement;
import org.autoplot.layout.LayoutUtil;
import org.autoplot.state.StatePersistence;
import org.das2.DasApplication;
import org.das2.beans.BeansUtil;
import org.das2.components.DasProgressPanel;
import org.das2.components.propertyeditor.EnumerationEditor;
import org.das2.datum.Datum;
import org.das2.datum.TimeParser;
import org.das2.datum.Units;
import org.das2.graph.DasCanvas;
import org.das2.qds.QDataSet;
import org.das2.util.ExceptionHandler;
import org.das2.util.FileUtil;
import org.das2.util.LoggerManager;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.filesystem.Glob;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.xml.sax.SAXException;

public final class ApplicationModel {
    DasApplication application;
    DasCanvas canvas;
    Timer tickleTimer;
    final Application dom;
    private ExceptionHandler exceptionHandler;
    boolean applet = false;
    private boolean sandboxed = false;
    private String prompt = "autoplot> ";
    public static final String PROP_PROMPT = "prompt";
    private static final Logger logger = LoggerManager.getLogger((String)"autoplot");
    private static final Logger bookmarksLogger = LoggerManager.getLogger((String)"autoplot.bookmarks");
    public static final String PREF_RECENT = "recent";
    public static final String PROPERTY_RECENT = "recent";
    public static final String PROPERTY_BOOKMARKS = "bookmarks";
    private static final int MAX_RECENT = 20;
    private boolean dontRecordHistory = false;
    private String name = "";
    public static final String PROP_NAME = "name";
    PropertyChangeListener timeSeriesBrowseListener;
    Caching caching = null;
    ProgressMonitor mon = null;
    protected List<Bookmark> recent = null;
    protected List<Bookmark> bookmarks = null;
    String lastRecent = "";
    long lastRecentTime = 0L;
    long lastRecentCount = 1L;
    private ResizeRequestListener resizeRequestListener = null;
    protected String vapFile = null;
    public static final String PROP_VAPFILE = "vapFile";
    private boolean restoringState = false;
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private final Map<RenderType, PlotStylePanel.StylePanel> panelCache = new HashMap<RenderType, PlotStylePanel.StylePanel>();

    public void setApplet(boolean v) {
        this.applet = v;
    }

    public boolean isApplet() {
        return this.applet;
    }

    public void setSandboxed(boolean sandboxed) {
        if (!sandboxed) {
            throw new IllegalArgumentException("sandboxed can only be set to true");
        }
        this.sandboxed = sandboxed;
    }

    public boolean isSandboxed() {
        return this.sandboxed;
    }

    public boolean isApplication() {
        return this.getDom().getController().getScriptContext().getViewWindow() != null;
    }

    public boolean isHeadless() {
        return "true".equals(DasApplication.getProperty((String)"java.awt.headless", (String)"false"));
    }

    public String getPrompt() {
        return this.prompt;
    }

    public void setPrompt(String prompt) {
        String oldPrompt = this.prompt;
        this.prompt = prompt;
        this.propertyChangeSupport.firePropertyChange(PROP_PROMPT, oldPrompt, prompt);
    }

    public ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public void setExceptionHandler(ExceptionHandler eh) {
        this.exceptionHandler = eh;
        DasApplication.getDefaultApplication().setExceptionHandler(this.exceptionHandler);
        FileSystem.setExceptionHandler((ExceptionHandler)this.exceptionHandler);
        String cl = eh.getClass().getName();
        if (cl.equals("org.autoplot.scriptconsole.GuiExceptionHandler")) {
            try {
                Method m = eh.getClass().getMethod("setApplicationModel", ApplicationModel.class);
                m.invoke((Object)eh, this);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
    }

    public void showMessage(String message, String title, int messageType) {
        if (!"true".equals(AutoplotUtil.getProperty("java.awt.headless", "false"))) {
            Component p = SwingUtilities.getRoot((Component)this.canvas);
            if (p == null) {
                switch (messageType) {
                    case 2: {
                        System.err.println("WARNING: " + title + ": " + message);
                        break;
                    }
                    case 1: {
                        System.err.println("INFO: " + title + ": " + message);
                        break;
                    }
                    default: {
                        System.err.println(title + ": " + message);
                        break;
                    }
                }
            } else {
                JOptionPane.showMessageDialog(p, message, title, messageType);
            }
        } else {
            switch (messageType) {
                case 2: {
                    System.err.println("WARNING: " + title + ": " + message);
                    break;
                }
                case 1: {
                    System.err.println("INFO: " + title + ": " + message);
                    break;
                }
                default: {
                    System.err.println(title + ": " + message);
                }
            }
        }
    }

    public ApplicationModel() {
        DataSetURI.init();
        this.dom = new Application();
        if (this.isHeadless()) {
            logger.fine("history.txt is not being recorded in headless mode");
            this.dontRecordHistory = true;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        String oldName = this.name;
        this.name = name;
        this.propertyChangeSupport.firePropertyChange(PROP_NAME, oldName, name);
    }

    public void addDasPeersToAppAndWait() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.addDasPeersToApp();
        } else {
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    ApplicationModel.this.addDasPeersToApp();
                }
            };
            try {
                SwingUtilities.invokeAndWait(run);
            }
            catch (InterruptedException | InvocationTargetException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public void addDasPeersToApp() {
        if (!this.applet) {
            BeansUtil.registerEditor(RenderType.class, EnumerationEditor.class);
            BeansUtil.registerEditor(MouseModuleType.class, EnumerationEditor.class);
        }
        new ApplicationController(this, this.dom);
        this.canvas = this.dom.getController().addCanvas();
        this.application = this.canvas.getApplication();
        this.dom.getController().addPlotElement(null, null);
    }

    public DasCanvas getCanvas() {
        return this.dom.getController().getDasCanvas();
    }

    public void setDataSet(QDataSet ds) {
        this.dom.getController().getPlotElement().getController().setResetRanges(true);
        DataSourceFilter dsf = this.dom.getController().getDataSourceFilter();
        if (dsf != null) {
            dsf.getController().setDataSource(null);
            dsf.setUri("vap+internal:");
            dsf.setFilters("");
            dsf.getController().setDataSetInternal(null);
            dsf.getController().setDataSetInternal(ds);
        } else {
            logger.warning("expected dsf to be non-null.");
        }
    }

    public void setDataSet(int chNum, String label, QDataSet ds) {
        this.setDataSet(chNum, label, ds, true);
    }

    public void setDataSet(int chNum, String label, QDataSet ds, boolean reset) {
        while (this.dom.getDataSourceFilters().length <= chNum) {
            Plot p = CanvasUtil.getMostBottomPlot(this.dom.getController().getCanvas());
            this.dom.getController().setPlot(p);
            this.dom.getController().addPlotElement(null, null);
        }
        DataSourceFilter dsf = this.dom.getDataSourceFilters(chNum);
        List<PlotElement> elements = this.dom.getController().getPlotElementsFor(dsf);
        if (!reset) {
            elements.forEach(pe -> pe.getController().setDsfReset(reset));
        }
        dsf.getController().setDataSource(null);
        dsf.setUri("vap+internal:");
        dsf.setFilters("");
        dsf.getController().setDataSetInternal(null);
        dsf.getController().setDataSetInternal(ds);
        if (label != null) {
            for (PlotElement pe2 : elements) {
                pe2.setLegendLabel(label);
                pe2.setDisplayLegend(true);
            }
        }
    }

    public void setDataSet(int chNum, String label, String suri) {
        while (this.dom.getDataSourceFilters().length <= chNum) {
            Plot p = CanvasUtil.getMostBottomPlot(this.dom.getController().getCanvas());
            this.dom.getController().setPlot(p);
            this.dom.getController().addPlotElement(null, null);
        }
        DataSourceFilter dsf = this.dom.getDataSourceFilters(chNum);
        List<PlotElement> elements = this.dom.getController().getPlotElementsFor(dsf);
        for (PlotElement pe : elements) {
            pe.getController().setResetPlotElement(true);
            pe.getController().setResetComponent(true);
        }
        dsf.getController().setDataSource(null);
        dsf.setUri(suri);
        if (label != null) {
            for (PlotElement pe : elements) {
                pe.setLegendLabel(label);
                pe.setDisplayLegend(true);
            }
        }
    }

    public void setFocus(int chNum) {
        while (this.dom.getDataSourceFilters().length <= chNum) {
            Plot p = CanvasUtil.getMostBottomPlot(this.dom.getController().getCanvas());
            this.dom.getController().setPlot(p);
            this.dom.getController().addPlotElement(null, null);
        }
        DataSourceFilter dsf = this.dom.getDataSourceFilters(chNum);
        this.dom.getController().setDataSourceFilter(dsf);
    }

    public void setDataSource(DataSource dataSource) {
        this.dom.getController().getDataSourceFilter().getController().resetDataSource(false, dataSource);
    }

    public DataSource dataSource() {
        DataSourceFilter dsf = this.dom.getController().getDataSourceFilter();
        if (dsf == null) {
            throw new NullPointerException("Expected dsf to be non-null");
        }
        return dsf.getController().getDataSource();
    }

    public synchronized void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public synchronized void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    protected void resetDataSetSourceURL(String suri, ProgressMonitor mon) {
        block12: {
            if (suri == null) {
                return;
            }
            URISplit split = URISplit.parse((String)suri);
            suri = URISplit.format((URISplit)split);
            try {
                if (split.file != null && (split.file.endsWith(".vap") || split.file.endsWith(".vapx"))) {
                    try {
                        suri = suri.replaceAll("\\\\", "/");
                        URI uri = DataSetURI.getURIValid((String)suri);
                        mon.started();
                        mon.setProgressMessage("loading vap file");
                        this.getDocumentModel().getController().setFocusUri(suri);
                        File openable = DataSetURI.getFile((URI)uri, (ProgressMonitor)this.application.getMonitorFactory().getMonitor(this.canvas, "loading vap", ""));
                        if (split.params != null) {
                            LinkedHashMap params = URISplit.parseParams((String)split.params);
                            if (params.containsKey("timerange") && !params.containsKey("timeRange")) {
                                params.put("timeRange", params.remove("timerange"));
                            }
                            params.put("PWD", split.path);
                            this.doOpenVap(openable, (LinkedHashMap<String, String>)params);
                        } else {
                            LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
                            params.put("PWD", split.path);
                            this.doOpenVap(openable, params);
                        }
                        mon.setProgressMessage("done loading vap file");
                        mon.finished();
                        break block12;
                    }
                    catch (HtmlResponseIOException ex) {
                        URL url = ex.getURL();
                        if (url == null) {
                            url = new URL(DataSetURI.getURIValid((String)suri).getSchemeSpecificPart());
                        }
                        HtmlResponseIOException neww = new HtmlResponseIOException(ex.getMessage(), url);
                        throw new RuntimeException(neww);
                    }
                    catch (IOException ex) {
                        mon.finished();
                        throw new RuntimeException(ex);
                    }
                }
                this.dom.getController().setFocusUri(null);
                this.dom.getController().setFocusUri(suri);
                this.getDataSourceFilterController().resetSuri(suri, mon);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (MalformedURLException | URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void setDataSourceURL(String suri) {
        DataSourceFilter dsf = this.dom.getController().getDataSourceFilter();
        if (dsf == null) {
            return;
        }
        String oldVal = dsf.getUri();
        if (suri == null && oldVal == null) {
            return;
        }
        if (suri != null && suri.equals(oldVal)) {
            return;
        }
        this.resetDataSetSourceURL(suri, (ProgressMonitor)new NullProgressMonitor());
    }

    public String getDataSourceURL() {
        DataSourceFilter dsf = this.dom.getController().getDataSourceFilter();
        if (dsf == null) {
            throw new NullPointerException("expected DSF to be non-null");
        }
        return dsf.getUri();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<Bookmark> getRecent() {
        boolean ok;
        if (this.recent != null) {
            return this.recent;
        }
        String nodeName = "recent";
        File f2 = new File(AutoplotSettings.settings().resolveProperty("autoplotData"), "bookmarks/");
        if (!f2.exists() && !(ok = f2.mkdirs())) {
            throw new RuntimeException("unable to create folder " + f2);
        }
        File f = new File(f2, nodeName + ".xml");
        if (f.exists()) {
            try {
                this.recent = Bookmark.parseBookmarks(AutoplotUtil.readDoc(new FileInputStream(f)).getDocumentElement(), 0);
                return this.recent;
            }
            catch (IOException | ParserConfigurationException | BookmarksException | SAXException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
                return new ArrayList<Bookmark>();
            }
        }
        Preferences prefs = AutoplotSettings.settings().getPreferences(ApplicationModel.class);
        String srecent = prefs.get("recent", "");
        if (srecent.equals("") || !srecent.startsWith("<")) {
            String srecenturl = AutoplotUtil.getProperty("autoplot.default.recent", "");
            if (srecenturl.equals("")) return new ArrayList<Bookmark>();
            try {
                URL url = new URL(srecenturl);
                this.recent = Bookmark.parseBookmarks(AutoplotUtil.readDoc(url.openStream()).getDocumentElement());
                prefs.put("recent", Bookmark.formatBooks(this.recent));
                try {
                    prefs.flush();
                }
                catch (BackingStoreException ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                }
            }
            catch (IOException | ParserConfigurationException | BookmarksException | SAXException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
                return new ArrayList<Bookmark>();
            }
        } else {
            try {
                this.recent = Bookmark.parseBookmarks(AutoplotUtil.readDoc(new ByteArrayInputStream(srecent.getBytes())).getDocumentElement());
            }
            catch (IOException | ParserConfigurationException | BookmarksException | SAXException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
                return new ArrayList<Bookmark>();
            }
        }
        this.addRecent("");
        return this.recent;
    }

    public List<Bookmark> getLegacyBookmarks() {
        Preferences prefs = AutoplotSettings.settings().getPreferences(ApplicationModel.class);
        String sbookmark = prefs.get(PROPERTY_BOOKMARKS, "");
        if (sbookmark.equals("") || !sbookmark.startsWith("<")) {
            String surl = AutoplotUtil.getProperty("autoplot.default.bookmarks", "https://autoplot.org/data/demos.xml");
            if (!surl.equals("")) {
                try {
                    URL url = new URL(surl);
                    this.bookmarks = Bookmark.parseBookmarks(AutoplotUtil.readDoc(url.openStream()).getDocumentElement());
                }
                catch (IOException | ParserConfigurationException | BookmarksException | SAXException e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                    return new ArrayList<Bookmark>();
                }
            }
        } else {
            try {
                this.bookmarks = Bookmark.parseBookmarks(AutoplotUtil.readDoc(new ByteArrayInputStream(sbookmark.getBytes())).getDocumentElement());
            }
            catch (SAXException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
                return new ArrayList<Bookmark>();
            }
            catch (IOException | ParserConfigurationException | BookmarksException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
                return new ArrayList<Bookmark>();
            }
        }
        return this.bookmarks;
    }

    public void addException(String suri, Exception exx) {
        boolean ok;
        if (!DasApplication.hasAllPermission()) {
            return;
        }
        if (!"true".equals(System.getProperty("enableLogExceptions"))) {
            return;
        }
        logger.fine("logging exception because of experimental.features");
        File f2 = new File(AutoplotSettings.settings().resolveProperty("autoplotData"), "bookmarks/");
        if (!f2.exists() && !(ok = f2.mkdirs())) {
            throw new RuntimeException("unable to create folder " + f2);
        }
        File f3 = new File(f2, "exceptions.txt");
        try (FileWriter out3 = new FileWriter(f3, true);){
            TimeParser tp = TimeParser.create((String)"$Y-$m-$dT$H:$M:$S.$(subsec;places=3)Z");
            Datum now = Units.t1970.createDatum((double)System.currentTimeMillis() / 1000.0);
            out3.append("=== " + tp.format(now, null) + " ===\n");
            out3.append(suri + "\n");
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            exx.printStackTrace(pw);
            out3.append(sw.toString());
            out3.append("\n");
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "exception: " + suri, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRecent(String suri) {
        String lookfor;
        File local;
        bookmarksLogger.log(Level.FINER, "addRecent ({0})", suri);
        if (!DasApplication.hasAllPermission()) {
            return;
        }
        if (suri.contains("nohistory=true")) {
            bookmarksLogger.fine("Not logging URI because it contains nohistory=true");
            return;
        }
        if (this.dontRecordHistory) {
            bookmarksLogger.finest("Not logging URI because history is turned off");
            return;
        }
        if (suri.contains("fscache") && suri.contains((local = new File(AutoplotSettings.settings().resolveProperty("fscache"))).toString())) {
            bookmarksLogger.fine("Reference to fscache will not be used in recent URIs.");
            return;
        }
        if (this.recent == null) {
            this.recent = new ArrayList<Bookmark>();
        }
        List<Bookmark> oldValue = Collections.unmodifiableList(this.recent);
        ArrayList<Bookmark> newValue = new ArrayList<Bookmark>(this.recent);
        if (suri.startsWith("vap+") && (lookfor = DataSetURI.blurTsbUri((String)suri)) != null) {
            ArrayList<Bookmark> rm = new ArrayList<Bookmark>();
            for (Bookmark b : newValue) {
                String suri1;
                String suri11;
                if (!(b instanceof Bookmark.Item) || !lookfor.equals(suri11 = DataSetURI.blurTsbUri((String)(suri1 = ((Bookmark.Item)b).getUri())))) continue;
                rm.add(b);
            }
            if (rm.size() > 0) {
                bookmarksLogger.log(Level.FINE, "removing {0} other TSB uris", rm.size());
                for (Bookmark o : rm) {
                    newValue.remove(o);
                }
            }
        }
        if (!suri.equals("")) {
            Bookmark.Item book = new Bookmark.Item(suri);
            if (newValue.contains(book)) {
                newValue.remove(book);
            }
            newValue.add(book);
        }
        while (newValue.size() > 20) {
            newValue.remove(0);
        }
        if (suri.equals(this.lastRecent)) {
            this.lastRecentTime = System.currentTimeMillis();
            ++this.lastRecentCount;
        } else {
            boolean ok;
            String nodeName = "recent";
            File f2 = new File(AutoplotSettings.settings().resolveProperty("autoplotData"), "bookmarks/");
            if (!f2.exists() && !(ok = f2.mkdirs())) {
                throw new RuntimeException("unable to create folder " + f2);
            }
            File f = new File(f2, nodeName + ".xml");
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(f);
                Bookmark.formatBooks(out, newValue);
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
            finally {
                try {
                    if (out != null) {
                        ((OutputStream)out).close();
                    }
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                }
            }
            File f3 = new File(f2, "history.txt");
            try (FileWriter out3 = new FileWriter(f3, true);){
                TimeParser tp = TimeParser.create((String)"$Y-$m-$dT$H:$M:$S.$(subsec;places=3)Z");
                long lnow = System.currentTimeMillis();
                if (this.lastRecent != null && this.lastRecentCount > 1L) {
                    Datum then = Units.t1970.createDatum((double)this.lastRecentTime / 1000.0);
                    out3.append(tp.format(then) + "\t" + this.lastRecent + "\n");
                }
                this.lastRecent = suri;
                this.lastRecentTime = lnow;
                this.lastRecentCount = 1L;
                Datum now = Units.t1970.createDatum((double)System.currentTimeMillis() / 1000.0);
                out3.append(tp.format(now, null) + "\t" + suri + "\n");
            }
            catch (IOException ex) {
                logger.log(Level.WARNING, ex.getMessage(), ex);
            }
        }
        this.recent = newValue;
        this.propertyChangeSupport.firePropertyChange("recent", oldValue, this.recent);
    }

    public Map<String, String> getRecent(String filter, int limit) {
        Pattern p = Glob.getPattern((String)filter);
        return this.getRecent(p, limit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getRecent(Pattern p, final int limit) {
        boolean ok;
        File f2 = new File(AutoplotSettings.settings().resolveProperty("autoplotData"), "bookmarks/");
        if (!f2.exists() && !(ok = f2.mkdirs())) {
            throw new RuntimeException("unable to create folder " + f2);
        }
        File f3 = new File(f2, "history.txt");
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, String> eldest) {
                return this.size() > limit;
            }
        };
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(f3));
            String line = reader.readLine();
            while (line != null) {
                String[] ss = line.split("\\s+", 2);
                if (ss.length > 1 && p.matcher(ss[1]).matches()) {
                    result.remove(ss[1]);
                    result.put(ss[1], ss[0]);
                }
                line = reader.readLine();
            }
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ex1) {
                    logger.log(Level.SEVERE, ex1.getMessage(), ex1);
                }
            }
        }
        return result;
    }

    public void exit() {
    }

    void resetZoom() {
        this.dom.getController().getPlot().getController().resetZoom(true, true, true);
    }

    private int stepForSize(int size) {
        int step = size < 20 ? 1 : (size < 40 ? 2 : 4);
        return step;
    }

    void increaseFontSize() {
        Font f = Font.decode(this.dom.getOptions().getCanvasFont());
        int size = f.getSize();
        int step = this.stepForSize(size);
        f = f.deriveFont((float)size + (float)step);
        this.dom.getOptions().setCanvasFont(DomUtil.encodeFont(f));
    }

    void decreaseFontSize() {
        Font f = Font.decode(this.dom.getOptions().getCanvasFont());
        int size = f.getSize();
        int step = this.stepForSize(size);
        f = f.deriveFont((float)size - (float)step);
        this.dom.getOptions().setCanvasFont(DomUtil.encodeFont(f));
    }

    void resetFontSize() {
        Font f = Font.decode(this.dom.getOptions().getCanvasFont());
        Font defaultFont = UIManager.getDefaults().getFont("TextPane.font");
        int size = defaultFont.getSize();
        f = f.deriveFont((float)size);
        this.dom.getOptions().setCanvasFont(DomUtil.encodeFont(f));
    }

    public Application createState(boolean deep) {
        Application state = (Application)this.dom.copy();
        return state;
    }

    private static BufferedImage resizeImageTo(BufferedImage im, int hf) {
        int h0 = im.getHeight();
        double aspect = 1.0 * (double)h0 / (double)im.getWidth();
        BufferedImage thumb = null;
        int h = hf * (int)Math.pow(2.0, (int)Math.ceil(Math.log10(1.0 * (double)h0 / (double)hf) / Math.log10(2.0)));
        if (h == h0) {
            h = h0 / 2;
        }
        while (h >= hf) {
            thumb = new BufferedImage((int)((double)h / aspect), h, 2);
            Graphics2D g = (Graphics2D)thumb.getGraphics();
            g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            AffineTransform tx = new AffineTransform();
            double scale = 1.0 * (double)h / (double)h0;
            tx.scale(scale, scale);
            g.drawImage(im, tx, null);
            if (h == hf) break;
            h0 = h;
            h = hf < h0 / 2 ? h0 / 2 : hf;
            im = thumb;
        }
        return thumb;
    }

    private void thickenLines(BufferedImage im) {
        int bc = im.getRGB(0, 0);
        for (int i = 0; i < im.getWidth() - 4; ++i) {
            for (int j = 0; j < im.getHeight() - 4; ++j) {
                int c0 = im.getRGB(i, j);
                if (c0 != bc) continue;
                int c = im.getRGB(i + 1, j);
                if (c != bc) {
                    im.setRGB(i, j, c);
                }
                if ((c = im.getRGB(i + 2, j)) != bc) {
                    im.setRGB(i, j, c);
                }
                if ((c = im.getRGB(i + 3, j)) != bc) {
                    im.setRGB(i, j, c);
                }
                if ((c = im.getRGB(i + 4, j)) != bc) {
                    im.setRGB(i, j, c);
                }
                if ((c = im.getRGB(i, j + 1)) != bc) {
                    im.setRGB(i, j, c);
                }
                if ((c = im.getRGB(i, j + 2)) != bc) {
                    im.setRGB(i, j, c);
                }
                if ((c = im.getRGB(i, j + 3)) != bc) {
                    im.setRGB(i, j, c);
                }
                if ((c = im.getRGB(i, j + 4)) == bc) continue;
                im.setRGB(i, j, c);
            }
        }
    }

    public BufferedImage getThumbnail(int height) {
        if (this.getCanvas().getWidth() == 0) {
            return null;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("must not be called on the EventQueue");
        }
        AWTEvent ev = Toolkit.getDefaultToolkit().getSystemEventQueue().peekEvent(46288);
        if (ev != null) {
            logger.fine("bug 917: not getting thumbnail, because it would cause hang.");
            return null;
        }
        int w = this.getCanvas().getPreferredSize().width;
        int h = this.getCanvas().getPreferredSize().height;
        logger.finer("getting image from canvas...");
        BufferedImage im = (BufferedImage)this.getCanvas().getImageNonPrint(w, h);
        logger.finer("got image from canvas.");
        if (im.getHeight() / height > 3) {
            this.thickenLines(im);
        }
        BufferedImage thumb = ApplicationModel.resizeImageTo(im, height);
        return thumb;
    }

    public void restoreState(Application state) {
        boolean resetFocus = DomUtil.structureChanges(state, this.dom);
        this.dom.syncTo(state);
        if (resetFocus) {
            this.dom.getController().setPlot(this.dom.getPlots(0));
        }
    }

    void doSave(File f) throws IOException {
        StatePersistence.saveState(f, (Object)this.createState(true), "");
        this.setVapFile(DataSetURI.fromFile((File)f));
        this.addRecent(DataSetURI.fromFile((File)f));
    }

    void doSave(File f, String scheme) throws IOException {
        StatePersistence.saveState(f, (Object)this.createState(true), scheme);
        this.setVapFile(DataSetURI.fromFile((File)f));
        this.addRecent(DataSetURI.fromFile((File)f));
    }

    void doSave(File f, String scheme, Map<String, Object> options) throws IOException {
        Application app = this.createState(true);
        if (options.getOrDefault("localPwdReferences", Boolean.FALSE) == Boolean.TRUE) {
            File pp = f.getParentFile();
            String spp = pp.getCanonicalPath();
            for (int i = 0; i < app.getDataSourceFilters().length; ++i) {
                File f1;
                DataSourceFilter dsf = app.getDataSourceFilters(i);
                String uri = dsf.getUri();
                URISplit split = URISplit.parse((String)uri);
                if (!split.file.startsWith("file:") || !(f1 = new File(split.file.substring(5)).getCanonicalFile()).getCanonicalPath().startsWith(spp)) continue;
                split.file = "%{PWD}" + f1.getCanonicalPath().substring(spp.length() + 1);
                dsf.setUri(URISplit.format((URISplit)split));
                app.setDataSourceFilters(i, dsf);
            }
        }
        StatePersistence.saveState(f, (Object)app, scheme);
        this.setVapFile(DataSetURI.fromFile((File)f));
        this.addRecent(DataSetURI.fromFile((File)f));
    }

    public void doOpenVap(File f, LinkedHashMap<String, String> deltas) throws IOException {
        if (!f.exists()) {
            throw new IllegalArgumentException("no such file: " + f);
        }
        if (f.length() == 0L) {
            throw new IllegalArgumentException("zero-length file: " + f);
        }
        Preferences prefs = AutoplotSettings.settings().getPreferences(AutoplotSettings.class);
        prefs.put("last_open_vap_file", f.getAbsolutePath());
        prefs.put("last_open_vap_folder", f.getParent());
        try (FileInputStream in = new FileInputStream(f);){
            this.doOpenVap(in, deltas);
            this.setVapFile(f.toString());
        }
    }

    public void setResizeRequestListener(ResizeRequestListener listener) {
        this.resizeRequestListener = listener;
    }

    public void setCanvasSize(int width, int height) {
        if (this.resizeRequestListener != null) {
            this.resizeRequestListener.resize(width, height);
        } else {
            Window w;
            if (!this.isHeadless() && (w = SwingUtilities.getWindowAncestor((Component)this.canvas)) != null) {
                Dimension windowDimension = w.getSize();
                Dimension canvasDimension = this.canvas.getSize();
                w.setSize(width + (windowDimension.width - canvasDimension.width), height + (windowDimension.height - canvasDimension.height));
            }
            Dimension d = new Dimension(width, height);
            this.canvas.setSize(d);
            this.canvas.setPreferredSize(d);
            this.dom.getCanvases(0).getController().setDimensions(width, height);
        }
    }

    public void setLocation(int x, int y) {
        Window w = SwingUtilities.getWindowAncestor((Component)this.canvas);
        w.setLocation(x, y);
    }

    public void doOpenVap(InputStream in, LinkedHashMap<String, String> deltas) throws IOException {
        Application state = StatePersistence.restoreState(in, deltas);
        if (DomUtil.structureChanges(this.dom, state)) {
            this.dom.getController().reset();
        }
        int correctHeight = state.getCanvases(0).getHeight();
        int correctWidth = state.getCanvases(0).getWidth();
        if (this.resizeRequestListener != null) {
            double scale = this.resizeRequestListener.resize(state.getCanvases(0).getWidth(), state.getCanvases(0).getHeight());
            Font f = Font.decode(state.getCanvases(0).getFont());
            Font newFont = f.deriveFont(f.getSize2D() * (float)scale);
            logger.log(Level.FINE, "shrinking font to {0}", newFont.toString());
            this.getCanvas().setBaseFont(newFont);
            Font f2 = this.getCanvas().getFont();
            this.getDom().getOptions().setCanvasFont(DomUtil.encodeFont(f2));
            state.getCanvases(0).setFont(DomUtil.encodeFont(newFont));
            state.getCanvases(0).setFitted(this.dom.getCanvases(0).isFitted());
            state.getCanvases(0).setWidth(this.dom.getCanvases(0).getWidth());
            state.getCanvases(0).setHeight(this.dom.getCanvases(0).getHeight());
        } else {
            this.setCanvasSize(correctWidth, correctHeight);
        }
        ArrayList<String> problems = new ArrayList<String>();
        if (!DomUtil.validateDom(state, problems)) {
            for (String p : problems) {
                System.err.println(p);
            }
        }
        this.restoreState(state);
        for (Plot p : this.dom.getPlots()) {
            boolean resetz;
            boolean resetx = p.getXaxis().isAutoRange() && !p.getXaxis().getAutoRangeHints().trim().isEmpty();
            boolean resety = p.getYaxis().isAutoRange() && !p.getYaxis().getAutoRangeHints().trim().isEmpty();
            boolean bl = resetz = p.getZaxis().isAutoRange() && !p.getZaxis().getAutoRangeHints().trim().isEmpty();
            if (!resetx && !resety && !resetz) continue;
            p.getController().resetZoom(resetx, resety, resetz);
        }
        if (this.dom.getCanvases(0).getHeight() != correctHeight || this.dom.getCanvases(0).getWidth() != correctWidth) {
            logger.warning("vap has been loaded but dimensions are not correct.");
        }
    }

    protected void doOpen(File f) throws IOException {
        this.doOpenVap(f, null);
    }

    public String getVapFile() {
        return this.vapFile;
    }

    public void setVapFile(String vapFile) {
        String old = this.vapFile;
        this.vapFile = vapFile;
        if (vapFile == null) {
            this.propertyChangeSupport.firePropertyChange(PROP_VAPFILE, old, null);
        } else {
            this.propertyChangeSupport.firePropertyChange(PROP_VAPFILE, null, vapFile);
        }
    }

    public void doAutoLayout() {
        ApplicationModel model = this;
        CanvasController controller = model.dom.getController().getCanvas().getController();
        ApplicationController applicationController = this.getDocumentModel().getController();
        controller.registerPendingChange(this, "autolayout");
        controller.performingChange(this, "autolayout");
        LayoutUtil.autolayout(applicationController.getDasCanvas(), applicationController.getRow(), applicationController.getColumn());
        controller.changePerformed(this, "autolayout");
    }

    public boolean isRestoringState() {
        return this.restoringState;
    }

    public void setRestoringState(boolean b) {
        this.restoringState = b;
    }

    boolean clearCache() throws IllegalArgumentException {
        File local = new File(AutoplotSettings.settings().resolveProperty("fscache"));
        boolean okay = true;
        HashSet<String> exclude = new HashSet<String>();
        exclude.add("ro_cache.txt");
        exclude.add("keychain.txt");
        okay = okay && FileUtil.deleteFileTree((File)new File(local, "http"), exclude);
        okay = okay && FileUtil.deleteFileTree((File)new File(local, "https"), exclude);
        okay = okay && FileUtil.deleteFileTree((File)new File(local, "ftp"), exclude);
        okay = okay && FileUtil.deleteFileTree((File)new File(local, "zip"), exclude);
        okay = okay && FileUtil.deleteFileTree((File)new File(local, "vfsCache"), exclude);
        okay = okay && FileUtil.deleteFileTree((File)new File(local, "fscache"), exclude);
        return okay;
    }

    boolean moveCache(File n) {
        File local = new File(AutoplotSettings.settings().resolveProperty("fscache"));
        DasProgressPanel mon1 = DasProgressPanel.createFramed((Window)SwingUtilities.getWindowAncestor((Component)this.getCanvas()), (String)"Moving Cache...");
        mon1.started();
        boolean y = Util.copyFileTree(local, n, 0, (ProgressMonitor)mon1);
        mon1.finished();
        if (y) {
            JOptionPane.showMessageDialog((Component)this.getCanvas(), "<html>File cache moved to<br>" + n + ".<br>The old cache (" + local + ") still contains data<br>and should manually be deleted.</html>", "Files moved", -1);
            AutoplotSettings.settings().setFscache(n.toString());
        } else {
            JOptionPane.showMessageDialog((Component)this.getCanvas(), "<html>Some problem occured, so the cache remains at the old location.</html>", "move files failed", 2);
        }
        return y;
    }

    public void waitUntilIdle(boolean runtimeException) {
        this.waitUntilIdle();
    }

    public void waitUntilIdle() {
        logger.log(Level.FINE, "enter waitUntilIdle, pendingChanges={0}", this.dom.getController().isPendingChanges());
        while (this.dom.getController().isPendingChanges()) {
            this.dom.getController().waitUntilIdle();
            logger.fine("waiting for canvas");
            this.canvas.waitUntilIdle();
        }
        this.canvas.waitUntilIdle();
        logger.fine("done waiting");
    }

    public Application getDocumentModel() {
        return this.dom;
    }

    public Application getDom() {
        return this.dom;
    }

    public DataSourceController getDataSourceFilterController() {
        DataSourceFilter dsf = this.dom.getController().getDataSourceFilter();
        if (dsf == null) {
            this.dom.getController().getDataSourceFilter();
            dsf = this.dom.getDataSourceFilters(0);
        }
        return dsf.getController();
    }

    public PlotStylePanel.StylePanel getStylePanelMaybeCached(RenderType renderType) {
        PlotStylePanel.StylePanel editorPanel = this.panelCache.get((Object)renderType);
        if (editorPanel == null) {
            editorPanel = GuiSupport.getStylePanel(renderType);
            this.panelCache.put(renderType, editorPanel);
        }
        return editorPanel;
    }

    public static interface ResizeRequestListener {
        public double resize(int var1, int var2);
    }
}

